/************************************ 框架升级前执行 ************************************/
ALTER TABLE `_of_com_mq` 
ADD COLUMN `mark` char(35) NOT NULL DEFAULT '' COMMENT '消息唯一ID(虚拟主机+队列名称+消息类型+消息ID)' FIRST,
ADD COLUMN `vHost` char(50) NOT NULL DEFAULT '' COMMENT '虚拟主机' AFTER `mark`,
MODIFY COLUMN `unId` char(32) NOT NULL DEFAULT '' COMMENT '消息唯一ID(队列名称+消息类型+消息ID)' AFTER `queue`,
MODIFY COLUMN `type` char(50) NOT NULL COMMENT '消息类型' AFTER `queue`,
MODIFY COLUMN `msId` char(100) NOT NULL DEFAULT '' COMMENT '消息ID' AFTER `type`,
ADD COLUMN `msgId` char(100) NOT NULL DEFAULT '' COMMENT '消息ID' AFTER `type`,
ADD COLUMN `lockMark` char(35) NOT NULL DEFAULT '' COMMENT '锁定时生成的唯一ID' AFTER `lockUnid`,
MODIFY COLUMN `lockUnid` char(32) NOT NULL DEFAULT '' COMMENT '锁定时生成的唯一ID' AFTER `lockTime`,
MODIFY COLUMN `updateTime` timestamp(0) NOT NULL DEFAULT '2000-01-01 00:00:00' COMMENT '消息最后更新时间' AFTER `syncCount`,
MODIFY COLUMN `createTime` timestamp(0) NOT NULL DEFAULT '2000-01-01 00:00:00' COMMENT '消息首次创建时间' AFTER `updateTime`,
MODIFY COLUMN `lockTime` timestamp(0) NOT NULL DEFAULT '2000-01-01 00:00:00' COMMENT '锁定时间, 每 syncLevel * 5 分钟重试' AFTER `syncLevel`;

CREATE TRIGGER `插入时升级数据` BEFORE INSERT ON `_of_com_mq` FOR EACH ROW SET
    NEW.msgId = IF(NEW.msId = '', NEW.msgId, NEW.msId),
    NEW.msId = IF(NEW.msId = '', NEW.msgId, NEW.msId),
    NEW.mark = MD5(CONCAT(NEW.`vHost`, CHAR(1), NEW.`queue`, CHAR(1), NEW.`type`, CHAR(1), NEW.`msgId`)),
    NEW.unId = MD5(CONCAT(NEW.`queue`, CHAR(1), NEW.`type`, CHAR(1), NEW.`msgId`)),
    NEW.lockMark = IF(NEW.lockUnid = '', NEW.lockMark, NEW.lockUnid);

CREATE TRIGGER `更新时升级数据` BEFORE UPDATE ON `_of_com_mq` FOR EACH ROW SET
    NEW.msgId = IF(NEW.msId = '', NEW.msgId, NEW.msId),
    NEW.msId = IF(NEW.msId = '', NEW.msgId, NEW.msId),
    NEW.mark = MD5(CONCAT(NEW.`vHost`, CHAR(1), NEW.`queue`, CHAR(1), NEW.`type`, CHAR(1), NEW.`msgId`)),
    NEW.unId = MD5(CONCAT(NEW.`queue`, CHAR(1), NEW.`type`, CHAR(1), NEW.`msgId`)),
    NEW.lockMark = IF(NEW.lockUnid = OLD.lockUnid, NEW.lockMark, NEW.lockUnid);

UPDATE
    `_of_com_mq`
SET
    `mark` = MD5(CONCAT(`vHost`, CHAR(1), `queue`, CHAR(1), `type`, CHAR(1), `msgId`))
WHERE
    `mark` = '';

UPDATE
    `_of_com_mq`
SET
    `lockMark` = `lockUnid`
WHERE
    `lockUnid` <> '';

ALTER TABLE `_of_com_mq` DROP PRIMARY KEY,
ADD PRIMARY KEY (`queue`, `unId`, `type`, `mark`) USING BTREE;

ALTER TABLE `_of_com_mq` PARTITION BY KEY (`type`) PARTITIONS 250;